<?php
/*

#####################################################################################
# NIST-developed software is provided by NIST as a public service. You may use, 
# copy and distribute copies of the software in any medium, provided that you 
# keep intact this entire notice. You may improve, modify and create derivative 
# works of the software or any portion of the software, and you may copy and 
# distribute such modifications or works. Modified works should carry a notice 
# stating that you changed the software and should note the date and nature of 
# any such change. Please explicitly acknowledge the National Institute of 
# Standards and Technology as the source of the software.
# 
# NIST-developed software is expressly provided “AS IS.” NIST MAKES NO WARRANTY 
# OF ANY KIND, EXPRESS, IMPLIED, IN FACT OR ARISING BY OPERATION OF LAW, 
# INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS 
# FOR A PARTICULAR PURPOSE, NON-INFRINGEMENT AND DATA ACCURACY. NIST NEITHER 
# REPRESENTS NOR WARRANTS THAT THE OPERATION OF THE SOFTWARE WILL BE 
# UNINTERRUPTED OR ERROR-FREE, OR THAT ANY DEFECTS WILL BE CORRECTED. NIST DOES 
# NOT WARRANT OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF THE SOFTWARE OR 
# THE RESULTS THEREOF, INCLUDING BUT NOT LIMITED TO THE CORRECTNESS, ACCURACY, 
# RELIABILITY, OR USEFULNESS OF THE SOFTWARE.
# 
# You are solely responsible for determining the appropriateness of using and 
# distributing the software and you assume all risks associated with its use, 
# including but not limited to the risks and costs of program errors, compliance 
# with applicable laws, damage to or loss of data, programs or equipment, and the 
# unavailability or interruption of operation. This software is not intended to 
# be used in any situation where a failure could cause risk of injury or damage 
# to property. The software developed by NIST employees is not subject to 
# copyright protection within the United States.
#####################################################################################
Author: James R. Lyle
*/
/*
include "ft_ss_head.php";
*/
$dribble = fopen('/tmp/dribble-update.txt','w');
fprintf($dribble,'Start');

// $root = trim(`find /media -maxdepth 2 -name FT-LOGS`).'/';

include_once('../include/global.php');
// calling is_ftlogs_mounted(1) with a value of 1 tells it not to print a message if 
// the user does not have a FT-LOGS drive attached.
$root = is_ftlogs_mounted(TRUE);
$isUpdate = 1; // setting this variable will help ft_ss_head.php in rendering the page when it's called later

if ($root) { // if the log drive is mounted, continue with our processing and work...
	$root = $root.'/';

	if (file_exists($root . 'ss_tool.txt')){
		$tool = file($root . 'ss_tool.txt');
		$need_tool = 0;
	} else {
		$tool[0] = 'none';
		$tool[1] = 'None';
		$need_tool = 1;
	}
	if (file_exists($root . 'ss_se.txt')){
		$engine = file($root . 'ss_se.txt');
		$need_se = 0;
	} else {
		$engine[0] = 'none';
		$need_se = 1;
	}
	if (file_exists($root . 'ss_ds.txt')){
		$ds = file($root . 'ss_ds.txt');
		$need_ds = 0;
	} else {
		$ds[0] = 'none';
		$need_ds = 1;
	}
	fprintf ($dribble,"Have tool %d, engine %d, data set %d\n",$need_tool,
		$need_se, $need_ds);
	$engine[0] = chop($engine[0]);
	$ds[0] = chop($ds[0]);
	$tool[0] = chop($tool[0]);
	$tool[1] = chop($tool[1]);
	fprintf($dribble,"Tool %s\n",$tool[0]);
	fprintf($dribble,"Tool Version %s\n",$tool[1]);
	fprintf($dribble,"Engine %s\n",$engine[0]);
	fprintf($dribble,"Data Set %s\n",$ds[0]);
	fprintf ($dribble, "<br>Start of form items list<br>\n");
	$keys = array_keys($_POST);
	foreach ($keys as $dongxi){
		fprintf ($dribble,"<br>DongXI: %s ",$dongxi);
		fprintf ($dribble," Value: [%s] \n",$_POST[$dongxi]);
	}

/*if (isset($_POST)){
	foreach ($keys as $dongxi){
		fprintf ($dribble,"<br>DongXI: %s ",$dongxi);
		fprintf ($dribble," Value: [%s] \n",$_POST[$dongxi]);
		fprintf ($dribble,"<br>DongXI: %s (%s)\n",$dongxi,$_POST($dongxi));
	}*/

	if (strcmp($_POST['what'],'Tool') == 0){
		$out = fopen($root.'ss_tool.txt','w');
		fprintf ($out,"%s\n%s",$_POST['toolname'],$_POST['toolversion']);
		$need_tool = 0;
	} elseif (strcmp($_POST['what'],'Engine') == 0){
		$log_dir = $_POST['Engine'];
		if (strcmp($log_dir,'Other') == 0){
			if (isset($_POST['se_name'])){
				if (strlen($_POST['se_name']) > 0){
				$log_dir = $_POST['Engine'].'_'.$_POST['se_name'];
				/*
				fprintf ($dribble,"*** se_name *** %s *** %s ****\n",$log_dir,
					*/
				fprintf ($dribble,"*** %d ***\n",strlen($_POST['se_name']));
				}
			}
		}
		fprintf ($dribble,"*** %s ***\n",$log_dir);
		$log_dir = $log_dir ;
		$out = fopen($root.'ss_se.txt','w');
		fprintf ($out,'%s',$log_dir);
		$need_se = 0;
		if (!file_exists($root.$log_dir)) {
			mkdir($root.$log_dir, 0777, true);
		}
	} elseif (strcmp($_POST['what'],'DataSet') == 0){
		$out = fopen($root.'ss_ds.txt','w');
		fprintf ($out,'%s',$_POST['DataSet']);
		$need_ds = 0;
	}
} else { // the user's log drive wasn't mounted; These vars need values. We don't
	// really know what we need/don't need b/c we can't access the log drive, so let's
	// just say we need everything...
	$need_tool = 1;
	$need_se = 1;
	$need_ds = 1;		
}

if ($need_tool == 1){
	include "ft_ss_record_tool.php";
} elseif ($need_se == 1){
	include "ft_ss_get_engine.php";
} elseif ($need_ds == 1){
	include "ft_ss_data_set.php";
} else {
	/*
	include "select-win-case.php";
	*/
	include "ft_ss_select_case.php";
}
/*
include "ft_ss_tail.php";
*/
?>

